//
//  AHKMArrayController.m
//  AH-K3001V Utilities
//
//  Created by FUJIDANA on 06/05/15.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.//
//

#import "AHKMArrayController.h"
#import "AHKMail.h"

@implementation AHKMArrayController

- (int)mailboxToBeShown
{
	return [mailboxSegmentedControl selectedSegment];
}

- (void)setMailboxToBeShown:(int)value
{
	[mailboxSegmentedControl setSelectedSegment:value];
	[self rearrangeObjects];
}

- (NSArray *)arrangeObjects:(NSArray *)objects
{
	int shownMailbox = [self mailboxToBeShown];
	if (shownMailbox == 0) {
		return [super arrangeObjects:objects];
	}
	
	NSMutableArray *newObjects = [NSMutableArray array];
	NSEnumerator *enumerator = [objects objectEnumerator];
	AHKMail *mail;
	while (mail = [enumerator nextObject]) {
		if (shownMailbox == 1 && [mail box] == AHKInboxMailBox) {
			[newObjects addObject:mail];
		} else if (shownMailbox == 2 && ([mail box] == AHKSentMailBox || [mail box] == AHKDraftMailBox)) {
			[newObjects addObject:mail];
		}
	}
	return [super arrangeObjects:newObjects];
}

@end
